---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-sa - システムアカウンティング統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **pacct_print/usracct_printの出力フォーマット詳細**：pdb.c/usrdb.cの内容を未読のため出力形式の詳細が要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/sa/main.c` 75-292行目（main関数全体）
- E-02: `usr.sbin/sa/main.c` 302-371行目（acct_load関数）
- E-03: `usr.sbin/sa/main.c` 63-67行目（グローバルフラグ変数定義）
- E-04: `usr.sbin/sa/main.c` 374-525行目（各種ソート比較関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | acctv3構造体からレコードを読み取る | E-02 (305行目: struct acctv3 ac) | ○ |
| C-02 | 22種類のオプションをサポート | E-01 (84行目のgetopt文字列) | ○ |
| C-03 | -uオプションで個別プロセス出力 | E-02 (361-366行目) | ○ |
| C-04 | -mオプションでユーザー別出力 | E-01 (136-137行目, 280行目) | ○ |
| C-05 | -sオプションでサマリーDB更新 | E-01 (214-264行目) | ○ |
| C-06 | AFORKフラグで'*'付与 | E-02 (345-346行目) | ○ |
| C-07 | 非ASCII/制御文字を'?'に置換 | E-02 (339行目) | ○ |
| C-08 | シグナルマスクでDB更新保護 | E-01 (222-233行目) | ○ |
| C-09 | 6種類のソートキーをサポート | E-04 (cmp_usrsys, cmp_avgusrsys, cmp_dkio等) | ○ |
| C-10 | -rオプションでソート順逆転 | E-04 (382行目: rflag ? rv : -rv) | ○ |
| C-11 | デフォルトソートはユーザー+システム時間 | E-03 (73行目: sa_cmp = cmp_usrsys) | ○ |
| C-12 | ファイル切り詰め失敗時にwarn出力 | E-01 (243行目) | ○ |
| C-13 | -fと-vの組み合わせ制約あり | E-01 (185-188行目) | ○ |
| C-14 | CPU時間はマイクロ秒→秒変換 | E-02 (364行目: / 1000000) | ○ |
| C-15 | pacct_print/usracct_printの出力フォーマット詳細 | **根拠なし**（pdb.c/usrdb.c未読） | △ |

## 4) 不足情報（Unknown / Missing）
- pdb.cおよびusrdb.cの実装詳細（出力フォーマット、DBレイアウト）
  - 候補：`usr.sbin/sa/pdb.c` / `usr.sbin/sa/usrdb.c` / `usr.sbin/sa/extern.h`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 出力フォーマットの詳細がpdb.c/usrdb.cに依存しており、未確認部分がある

## 6) レビュアーチェックリスト（最小）
- [ ] pdb.c/usrdb.cの出力フォーマットとの整合性を確認
- [ ] extern.hのcmdinfo構造体フィールドの完全性を確認
- [ ] -sオプション時のDB更新のアトミック性を確認
